//To plot the magnitude and phase response of continuous time signal
//scilab 5.4.1;64 bit(windows 8)
stacksize max
clc; clear;close;
A =1; // Amplitude
Dt = 0.005;
t = 0: Dt :10;
xt = exp(-A*t);
// Continuous time Fourier Transform
Wmax =2*%pi*1; // Analog Frequency = 1Hz
K = 4;
k = 0:(K/1000):K;
W = k* Wmax /K;
XW = xt*exp(-sqrt(-1)*t'*W)*Dt
XW_Mag =abs(XW);
W = [-mtlb_fliplr(W),W(2:1001)]; // Omega from -Wmax to Wmax
XW_Mag=[mtlb_fliplr(XW_Mag ),XW_Mag(2:1001)];
[XW_Phase ,db] = phasemag (XW);
XW_Phase = [-mtlb_fliplr( XW_Phase ),XW_Phase(2:1001)];
// Plotting Continuous Time Signal
subplot(3,1,1)
a=gca();
a.y_location = "origin";
plot2d(t,xt);
xlabel( 't in sec .');
ylabel(' x(t) ')
title(' Continuous Time Signal ' )

// Plotting Magnitude Response of CTS
subplot (3 ,1 ,2);
a = gca ();
a.y_location = "origin";
plot2d(W, XW_Mag,style=5 );
xlabel ( ' Frequency in Radians / Seconds---> W' );
ylabel ( ' abs (X(jW) ) ' )
title ( 'Magnitude Response (CTFT) ' )
// Plotting Phase Reponse of CTS
subplot (3 ,1 ,3);
a =gca();
a.y_location="origin";
a.x_location="origin";
plot2d(W, XW_Phase *%pi/180,style=3);
xlabel(' Frequency in Radians / Seconds---> W');
ylabel('<X(jW) ')
title(' Phase Response (CTFT)in Radians' )
mprintf('|F(w)|= 1/sqrt(a^2+w^2) and\n Theta(w)=-atan(w/a)')

